require('dotenv').config();
const axios = require('axios');

const getPaymentStatuses = async (req, res) => {
  try {
    const response = await axios.get('https://www.asaas.com/api/v3/payments', {
      headers: {
        'access_token': process.env.TOKEN
      }
    });
    // const statuses = response.data.data
    //   .filter(item => item.customer === process.env.COSTUMER_ID)
    //   .map(item => item.status);
    //res.status(200).json({ statuses });

    const resp = response.data.data
    res.status(200).json({ resp });

  } catch (error) {
    console.error(error.response.data);
    res.status(500).json({ error: 'Internal Server Error' });
  }
};

module.exports = { getPaymentStatuses };
