const controllers = {}

//import model and sequalize

var sequelize = require('../model/database');
var card = require('../model/Cards');
//const CardHelper = require('../helpers/CardsHelper');
sequelize.sync();

controllers.list = async (req, res) => {
    const data = await card.findAll()
    .then(function(data){
        //CardHelper.updateCards();
        return data;
    })
    .catch(error => {
        return error;
    })

    res.json({
        success: true,
        data: data
    });
}

controllers.create = async(req, res) => {
    const {laneId, ticketId, title, description, label, status, dragable} = req.body;

    const data = await card.create({
        laneId:laneId,
        ticketId:ticketId,
        title:title,
        description:description,
        label:label,
        status:status,
        dragable:dragable
        
    })
    .then(function(data){
        return data;
    })
    .catch(error=>{
        console.log(error);
        return error;
    })

    res.status(200).json({
        success: true,
        message: "Cards setado com sucesso.",
        data: data
    })
}

controllers.get = async(req, res) => {
    const { id } = req.params;

    const data  = await card.findAll({
        where: {id : id}
    })
    .then(function(data){
        return data;
    })
    .catch(error=>{
        console.log(error);
        return error;
    })

    res.json({
        success:true,
        data: data
    })
}

controllers.update = async (req,res) => {
    // parameter get id
    const { id } = req.params;
    // parameter POST
    const {laneId, ticketId, title, description, label, status, dragable } = req.body;
    // Update data
    const data = await card.update({
        laneId:laneId,
        ticketId:ticketId,
        title:title,
        description:description,
        label:label,
        status:status,
        dragable:dragable
    },
    {
      where: { id: id}
    })
    .then( function(data){
      return data;
    })
    .catch(error => {
      return error;
    }) 
    res.json({success:true, data:data, message:"Cards atualizado com sucesso"});
  }

  controllers.delete = async (req, res) => {
    // parameter post
    const { id } = req.body;
    // delete sequelize
    const del = await card.destroy({
      where: { id: id}
    })
    res.json({success:true,deleted:del,message:"Cards apagado com sucesso."});
  }

module.exports = controllers;