const controllers = {}

//import model and sequalize

var sequelize = require('../model/database');
var lane = require('../model/Lanes');

sequelize.sync();

controllers.list = async (req, res) => {
    const data = await lane.findAll()
    .then(function(data){
        return data;
    })
    .catch(error => {
        return error;
    })

    res.json({
        success: true,
        data: data
    });
}

controllers.create = async(req, res) => {
    const {laneId, title, label} = req.body;

    const data = await lane.create({
        laneId:laneId,
        title:title,
        label:label
    })
    .then(function(data){
        return data;
    })
    .catch(error=>{
        console.log(error);
        return error;
    })

    res.status(200).json({
        success: true,
        message: "Lane criado com sucesso.",
        data: data
    })
}

controllers.get = async(req, res) => {
    const { id } = req.params;

    const data  = await lane.findAll({
        where: {id : id}
    })
    .then(function(data){
        return data;
    })
    .catch(error=>{
        console.log(error);
        return error;
    })

    res.json({
        success:true,
        data: data
    })
}

controllers.update = async (req,res) => {
    // parameter get id
    const { id } = req.params;
    // parameter POST
    const {laneId, title, label } = req.body;
    // Update data
    const data = await lane.update({
        laneId:laneId,
        title:title,
        label:label
    },
    {
      where: { id: id}
    })
    .then( function(data){
      return data;
    })
    .catch(error => {
      return error;
    }) 
    res.json({success:true, data:data, message:"Lane atualizado com sucesso"});
  }

  controllers.delete = async (req, res) => {
    // parameter post
    const { id } = req.body;
    // delete sequelize
    const del = await lane.destroy({
      where: { id: id}
    })
    res.json({success:true,deleted:del,message:"Lane apagado com sucesso."});
  }

module.exports = controllers;