const mysql = require('mysql2/promise');

const createConnection = async () => {
	return await mysql.createConnection({
		host: process.env.DB_HOST,
		user: process.env.DB_USER,
		password: process.env.DB_PASS,
		database: process.env.DB_NAME
	});
}

function delay(t, v) {
	return new Promise(function(resolve) { 
		setTimeout(resolve.bind(null, v), t)
	});
}

const updateCards = async () => {
	const connection = await createConnection();
	const query = `
		INSERT INTO cards (laneId, ticketId, title, description, label)
		SELECT t1.id, t1.id, t1.id, t1.id, t1.id
		FROM Tickets t1
		WHERE t1.id NOT IN (SELECT ticketId FROM cards);

		UPDATE Cards c
		JOIN Tickets t ON c.ticketId = t.id
		JOIN Contacts ct ON t.contactId = ct.id
		SET c.title = ct.name,
			c.description = ct.number;

		UPDATE Cards
		SET laneId = 'lane1'
		WHERE laneId NOT LIKE '%lane%';
		`;
	const [rows] = await connection.execute(query);
	delay(10000).then(async function() {
		await connection.end();
		delay(500).then(async function() {
			connection.destroy();
			//console.log('© BOT-ZDG Conexão fechada')
		});
		//console.log('© BOT-ZDG Conexão fechada')
	});
	if (rows.length > 0) return true;
	return false;
}

module.exports = {
	createConnection,
	updateCards
}