const Sequelize = require('sequelize');
var sequelize = require('./database');

var nametable = 'card';

var card = sequelize.define(nametable, {
    id:{
        type:Sequelize.INTEGER,
        primaryKey:true,
        autoIncrement:true
    },
    laneId: Sequelize.TEXT('long'),
    ticketId: Sequelize.TEXT('long'),
    title: Sequelize.TEXT('long'),
    description: Sequelize.TEXT('long'),
    label: Sequelize.TEXT('long'),
    status: Sequelize.TEXT('long'),
    dragable: {
        type: Sequelize.STRING,
        defaultValue: true
    },
    createdAt:{
        type: 'TIMESTAMP',
        defaultValue: Sequelize.literal('CURRENT_TIMESTAMP'),
        allowNull: false
    },
    updatedAt: {
        type: 'TIMESTAMP',
        defaultValue: Sequelize.literal('CURRENT_TIMESTAMP'),
        allowNull: false
    }
}) 

module.exports = card;