"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.removeWbot = exports.getWbot = exports.initWbot = void 0;
const qrcode_terminal_1 = __importDefault(require("qrcode-terminal"));
const whatsapp_web_js_1 = require("whatsapp-web.js");
const socket_1 = require("./socket");
const AppError_1 = __importDefault(require("../errors/AppError"));
const logger_1 = require("../utils/logger");
const wbotMessageListener_1 = require("../services/WbotServices/wbotMessageListener");
const db = require('../helpers/Db');
const SetDialogContact = __importDefault(require("../helpers/SetDialogContact"));
const GetDialogContact = __importDefault(require("../helpers/GetDialogContact"));
const SetDialogAudioContact = __importDefault(require("../helpers/SetDialogAudioContact"));
const GetDialogAudioContact = __importDefault(require("../helpers/GetDialogAudioContact"));
const SetN8NContact = __importDefault(require("../helpers/SetN8NContact"));
const GetN8NContact = __importDefault(require("../helpers/GetN8NContact"));
const SetChatBotContact = __importDefault(require("../helpers/SetChatBotContact"));
const GetChatBotContact = __importDefault(require("../helpers/GetChatBotContact"));
const SetTagContact = __importDefault(require("../helpers/SetTagContact"));
const GetTagContact = __importDefault(require("../helpers/GetTagContact"));
const SetGPTContact = __importDefault(require("../helpers/SetGPTContact"));
const GetGPTContact = __importDefault(require("../helpers/GetGPTContact"));
const sessions = [];
const util = require('util');
const {struct} = require('pb-util');
const fs = require('fs');
const {MessageMedia} = require("whatsapp-web.js");
const request = require('request');
const nodeCron = require("node-cron");

//data agendamento
const dataZDGAtual = new Date();
const diaZDG = ("0" + dataZDGAtual.getDate()).slice(-2);
const mesZDG = ("0" + (dataZDGAtual.getMonth() + 1)).slice(-2);
const anoZDG = dataZDGAtual.getFullYear();
const date = anoZDG + "-" + mesZDG + "-" + diaZDG;

//webhook dialogflow
const express = require('express');
const app2 = express();
const {WebhookClient} = require('@google-cloud/dialogflow');
const dialogflow = require('@google-cloud/dialogflow');

//webhook dialogflow
app2.post('/webhook', function(request,response){
    const agent = new WebhookClient ({ request, response });
    let intentMap = new Map();
    intentMap.set('nomedaintencao', nomedafuncao)
    agent.handleRequest(intentMap);
}); 
function nomedafuncao (agent) {
}  
app2.use(express.json());
app2.use(express.urlencoded({
    extended: true
}));
function isBlank(str) {
    return (!str || /^\s*$/.test(str));
}
const sessionClient = new dialogflow.SessionsClient({keyFilename: process.env.DIALOG_FLOW_JSON});

// config openai
const { Configuration, OpenAIApi } = require('openai')
const configuration = new Configuration({
    organization: process.env.ORGANIZATIONGPT,
    apiKey: process.env.APIKEYGPT,
});
const openai = new OpenAIApi(configuration);

//start wt
const syncUnreadMessages = (wbot) => __awaiter(void 0, void 0, void 0, function* () {
    const chats = yield wbot.getChats();
    /* eslint-disable no-restricted-syntax */
    /* eslint-disable no-await-in-loop */
    for (const chat of chats) {
        if (chat.unreadCount > 0) {
            const unreadMessages = yield chat.fetchMessages({
                limit: chat.unreadCount
            });
            for (const msg of unreadMessages) {
                yield wbotMessageListener_1.handleMessage(msg, wbot);
            }
            yield chat.sendSeen();
        }
    }
});

exports.initWbot = (whatsapp) => __awaiter(void 0, void 0, void 0, function* () {
    return new Promise((resolve, reject) => {
        try {
            const io = socket_1.getIO();
            const sessionName = whatsapp.name;
            let sessionCfg;
            if (whatsapp && whatsapp.session) {
                sessionCfg = JSON.parse(whatsapp.session);
            }
            const wbot = new whatsapp_web_js_1.Client({
                session: sessionCfg,
                authStrategy: new whatsapp_web_js_1.LocalAuth({ clientId: 'bd_' + whatsapp.id }),
                puppeteer: {
                    //          headless: false,
                    args: ['--no-sandbox', '--disable-setuid-sandbox'],
                    executablePath: process.env.CHROME_BIN || undefined
                },
            });
            wbot.initialize();
            wbot.on("qr", (qr) => __awaiter(void 0, void 0, void 0, function* () {
                const getWppAgendamento = yield db.getWhatsAppAgendamento(whatsapp.id)
                if (getWppAgendamento == false){
                    yield db.setWhatsAppAgendamento(whatsapp.name, whatsapp.id)
                    logger_1.logger.info('BOT-ZDG - Conexão ' + whatsapp.id +  ' setada na tabela de agendamento')
                }
                else {
                    logger_1.logger.info('BOT-ZDG - Conexão já existe na tabela de agendamento')
                }
                logger_1.logger.info("Session:", sessionName);
                qrcode_terminal_1.default.generate(qr, { small: true });
                yield whatsapp.update({ qrcode: qr, status: "qrcode", retries: 0 });
                const sessionIndex = sessions.findIndex(s => s.id === whatsapp.id);
                if (sessionIndex === -1) {
                    wbot.id = whatsapp.id;
                    sessions.push(wbot);
                }
                io.emit("whatsappSession", {
                    action: "update",
                    session: whatsapp
                });
                if (process.env.qrcode === "on") {
                    try {
                        function gerarQrCode() {
                            qrcode_terminal_1.default.generate(qr, { small: true }, function (qrCode) {
                            const base64Data = qrCode.replace(/^data:image\/png;base64,/, '');
                            const requestOptions = {
                                url: process.env.N8N_WEBHOOK,
                                method: 'POST',
                                body: base64Data + '\n\n Id: ' + whatsapp.id + ' - Nome: ' + whatsapp.name,
                                headers: {
                                'Content-Type': 'image/png',
                                },
                            };
                            request(requestOptions, function (error, response, body) {
                                if (error) {
                                console.error(error);
                                } else {
                                logger_1.logger.info('BOT-ZDG - Webhook QRCode enviado com sucesso.');
                                }
                            });
                            });
                        }
                        gerarQrCode();
                    } catch(e){
                    }
                }
            }));
            wbot.on("authenticated", (session) => __awaiter(void 0, void 0, void 0, function* () {
                logger_1.logger.info(`Session: ${sessionName} AUTHENTICATED`);
            }));
            wbot.on("auth_failure", (msg) => __awaiter(void 0, void 0, void 0, function* () {
                console.error(`Session: ${sessionName} AUTHENTICATION FAILURE! Reason: ${msg}`);
                if (whatsapp.retries > 1) {
                    yield whatsapp.update({ session: "", retries: 0 });
                }
                const retry = whatsapp.retries;
                yield whatsapp.update({
                    status: "DISCONNECTED",
                    retries: retry + 1
                });
                io.emit("whatsappSession", {
                    action: "update",
                    session: whatsapp
                });
                reject(new Error("Error starting whatsapp session."));
            }));
            wbot.on("ready", () => __awaiter(void 0, void 0, void 0, function* () {
                const statusAgendamentoWpp = yield db.getWhatsAppAgendamentoStatus(whatsapp.id);
                const statusAgendamento = yield db.getAppAgendamentoStatus();
                const GetControleAgendamentoWpp = yield db.getWhatsAppAgendamentoControle(whatsapp.id);
                const task = nodeCron.schedule("*/120 * * * * *", async function zdgAgendamento() {
                    await db.setWhatsAppAgendamentoControle(GetControleAgendamentoWpp + 1, whatsapp.id);
                    const agendamentos = await db.getAgendamento(date)
                        for (const agendamento of agendamentos){
                            const date = new Date();
                            const horaZDG = date.getHours() + ":" + date.getMinutes() + ":" + date.getSeconds();
                            const horaZDGAgendada = agendamento.horarioEnvio;
                            if (horaZDG < horaZDGAgendada){
                                logger_1.logger.info('BOT-ZDG - ' + date + ' - Mensagem ID: ' + agendamento.id + ', ainda não atingiu o horário agendado.')
                            }
                            else {
                                const groupCheck = await db.getContactIsGroup(agendamento.destinatario);
                                if(groupCheck === 0 && groupCheck !== false){
                                    wbot.sendMessage(agendamento.destinatario + '@c.us', agendamento.mensagem)
                                    db.setAgendamento(agendamento.id)
                                }
                                if(groupCheck === 1 && groupCheck !== false){
                                    wbot.sendMessage(agendamento.destinatario + '@g.us', agendamento.mensagem)
                                    db.setAgendamento(agendamento.id)
                                }
                                if(groupCheck === false){
                                    try {
                                        wbot.sendMessage(agendamento.destinatario + '@c.us', agendamento.mensagem)
                                        db.setAgendamento(agendamento.id)
                                    }
                                    catch(e){
                                        try {
                                            wbot.sendMessage(agendamento.destinatario + '@g.us', agendamento.mensagem)
                                            db.setAgendamento(agendamento.id)
                                        }
                                        catch(e){
                                            logger_1.logger.warn('BOT-ZDG: Erro agendamento: ' + e)
                                        }
                                    }
                                }
                            }
                        }
                    }
                );
                if(statusAgendamento === 'ok'){
                    if ( statusAgendamentoWpp === 'ok' && GetControleAgendamentoWpp < 1) {
                        logger_1.logger.info('BOT-ZDG - Processo de agendamento ativado para para conexao: ' + whatsapp.id)
                        task.start();
                    }
                    if ( statusAgendamentoWpp === 'off') {
                        logger_1.logger.info('BOT-ZDG - Processo de agendamento desativado para para conexao: ' + whatsapp.id)
                        yield db.delWhatsAppAgendamentoControle(whatsapp.id);
                        task.stop();
                    }
                }
                if(statusAgendamento === 'off'){
                    if ( statusAgendamentoWpp === 'ok' || statusAgendamentoWpp === 'off') {
                        logger_1.logger.info('BOT-ZDG - Processo de agendamento desativado para para conexao: ' + whatsapp.id)
                        yield db.delWhatsAppAgendamentoControle(whatsapp.id);
                        task.stop();
                    }
                }
                logger_1.logger.info(`Session: ${sessionName} READY`);
                yield whatsapp.update({
                    status: "CONNECTED",
                    qrcode: "",
                    retries: 0
                });
                io.emit("whatsappSession", {
                    action: "update",
                    session: whatsapp
                });
                const sessionIndex = sessions.findIndex(s => s.id === whatsapp.id);
                if (sessionIndex === -1) {
                    wbot.id = whatsapp.id;
                    sessions.push(wbot);
                }
                wbot.sendPresenceAvailable();
                yield syncUnreadMessages(wbot);
                resolve(wbot);
            }));
            wbot.on('message', async msg => {
                //getGrupos
                function delay(t, v) {
                    return new Promise(function(resolve) { 
                        setTimeout(resolve.bind(null, v), t)
                    });
                }
                const chatGroup = await msg.getChat();
                const groupConfig = await db.getGrupo();
                if (chatGroup.isGroup === true && groupConfig === 'off'){
                    return;
                }
                const number = msg.from.replace(/\D/g,'');
                const getDialogFlowContact = await GetDialogContact.default(number);
                if (getDialogFlowContact === true){
                    //console.log('BOT-ZDG: Contato já existe para o DialogFlow');
                }
                if (getDialogFlowContact === false){
                    //console.log('BOT-ZDG: Contato adicionado para o DialogFlow');
                    await SetDialogContact.default(number);
                }
                const getDialogFlowAudioContact = await GetDialogAudioContact.default(number);
                if (getDialogFlowAudioContact === true){
                    //console.log('BOT-ZDG: Contato já existe para o DialogFlow Audio');
                }
                if (getDialogFlowAudioContact === false){
                    //console.log('BOT-ZDG: Contato adicionado para o DialogFlow Audio');
                    await SetDialogAudioContact.default(number);
                }
                const getN8NContact = await GetN8NContact.default(number);
                if (getN8NContact === true){
                    //console.log('BOT-ZDG: Contato já existe para o N8N');
                }
                if (getN8NContact === false){
                    //console.log('BOT-ZDG: Contato adicionado para o N8N');
                    await SetN8NContact.default(number);
                }
                const getGPTContact = await GetGPTContact.default(number);
                if (getGPTContact === true){
                    //console.log('BOT-ZDG: Contato já existe para o N8N');
                }
                if (getGPTContact === false){
                    //console.log('BOT-ZDG: Contato adicionado para o N8N');
                    await SetGPTContact.default(number);
                }
                const getChatBotContact = await GetChatBotContact.default(number);
                if (getChatBotContact === true){
                    //console.log('BOT-ZDG: Contato já existe para o BOT MySQL');
                }
                if (getChatBotContact === false){
                    //console.log('BOT-ZDG: Contato adicionado para o BOT MySQL');
                    await SetChatBotContact.default(number);
                }
                const getTagContact = await GetTagContact.default(number);
                if (getTagContact === true){
                    //console.log('BOT-ZDG: Contato já existe para o BOT MySQL');
                }
                if (getTagContact === false){
                    //console.log('BOT-ZDG: Contato adicionado para o BOT MySQL');
                    await SetTagContact.default(number);
                }
                const date = new Date();
                const horaAtual = date.getHours();
                if (horaAtual < 10){
                    const atual = "0" + date.getHours() + ":" + date.getMinutes() + ":" + date.getSeconds();
                    const inicioAtendimento = await db.getHorarioInicio();
                    const terminoAtendimento = await db.getHorarioTermino();
                    // console.log('hora atual: ' + atual);
                    // console.log('inicio atendimento: ' + inicioAtendimento);
                    // console.log('termino atendimento: ' + terminoAtendimento);
                    if (atual > inicioAtendimento && atual < terminoAtendimento){   
                        logger_1.logger.info("BOT-ZDG: Dentro do horário de atendimento");
                    }
                    else {
                        if (msg.from === "status@broadcast" ) {
                            return false;
                        }
                        if (msg.type === "ciphertext"  ){
                            return false;
                        }
                        if (msg.body === null ){
                            return false;
                        }
                        if (msg.type === "e2e_notification" ){
                            return false;
                        }
                        if (msg.type === "notification_template" ){
                            return false;
                        }
                        else {
                            logger_1.logger.info("BOT-ZDG: Fora do horário de atendimento");
                            delay(3000).then(function() {
                                msg.reply("O horário de atendimento é entre " + inicioAtendimento + " e " + terminoAtendimento + ".");
                            });  
                        }
                    }
                }
                if (horaAtual >= 10){
                    const atual = date.getHours() + ":" + date.getMinutes() + ":" + date.getSeconds();
                    const inicioAtendimento = await db.getHorarioInicio();
                    const terminoAtendimento = await db.getHorarioTermino();
                    // console.log('hora atual: ' + atual);
                    // console.log('inicio atendimento: ' + inicioAtendimento);
                    // console.log('termino atendimento: ' + terminoAtendimento);
                    if (atual > inicioAtendimento && atual < terminoAtendimento){   
                        logger_1.logger.info("BOT-ZDG: Dentro do horário de atendimento");
                    }
                    else {
                        if (msg.from === "status@broadcast" ) {
                            return false;
                        }
                        if (msg.type === "ciphertext"  ){
                            return false;
                        }
                        if (msg.body === null ){
                            return false;
                        }
                        if (msg.type === "e2e_notification" ){
                            return false;
                        }
                        if (msg.type === "notification_template" ){
                            return false;
                        }
                        else {
                            logger_1.logger.info("BOT-ZDG: Fora do horário de atendimento");
                            delay(3000).then(function() {
                                msg.reply("O horário de atendimento é entre " + inicioAtendimento + " e " + terminoAtendimento + ".");
                            });  
                        }
                    }
                }
            });
            // wbot n8n
            wbot.on('message', async msg => {
                //getGrupos
                const chatGroup = await msg.getChat();
                const groupConfig = await db.getGrupo();
                if (chatGroup.isGroup === true && groupConfig === 'off'){
                    return;
                }
                function delay(t, v) {
                    return new Promise(function(resolve) { 
                        setTimeout(resolve.bind(null, v), t)
                    });
                }
                delay(2000).then(async function() {
                wbot.sendPresenceAvailable();
                if (process.env.N8N === "on") {
                    logger_1.logger.info("BOT-ZDG: ENV Config N8N On")
                    const n8nStatus = await db.getN8N(msg.from.split('@')[0]);
                    const date = new Date();
                    const horaAtual = date.getHours();
                    if (horaAtual < 10){
                        const atual = "0" + date.getHours() + ":" + date.getMinutes() + ":" + date.getSeconds();
                        const inicioAtendimento = await db.getHorarioInicio();
                        const terminoAtendimento = await db.getHorarioTermino();
                        if (atual > inicioAtendimento && atual < terminoAtendimento){
                            if (n8nStatus === "ok"){
                                logger_1.logger.info("BOT-ZDG: Config N8N ON");
                                var method = "message"
                                var options = {
                                    'method': 'POST',
                                    'url': process.env.N8N_WEBHOOK,
                                    'headers': {
                                    'Content-Type': 'application/json'
                                    },
                                    json: { msg, method }
                                };
                            
                                request(options, function (error, response) {
                                    if (error) {
                                    throw new Error(error);
                                    }
                                    else {
                                    logger_1.logger.info('BOT-ZDG - Webhook N8N enviado com sucesso.');
                                    }
                                });
                            }
                            if (n8nStatus === "off"){
                                logger_1.logger.info("BOT-ZDG: Config N8N Off");
                            }
                        }
                        else {
                            logger_1.logger.warn("BOT-ZDG: Fora do horário de atendimento - N8N");
                            // delay(3000).then(function() {
                            //     //msg.reply("O horário de atendimento é entre " + inicioAtendimento.split(':')[0] + ":" + inicioAtendimento.split(':')[1] + " e " + terminoAtendimento.split(':')[0] + ":" + terminoAtendimento.split(':')[1]);
                            // }); 
                        }
                    }
                    if (horaAtual >= 10){
                        const atual = date.getHours() + ":" + date.getMinutes() + ":" + date.getSeconds();
                        const inicioAtendimento = await db.getHorarioInicio();
                        const terminoAtendimento = await db.getHorarioTermino();
                        if (atual > inicioAtendimento && atual < terminoAtendimento){
                            if (n8nStatus === "ok"){
                                logger_1.logger.info("BOT-ZDG: Config N8N ON");
                                var method = "message"
                                var options = {
                                    'method': 'POST',
                                    'url': process.env.N8N_WEBHOOK,
                                    'headers': {
                                    'Content-Type': 'application/json'
                                    },
                                    json: { msg, method }
                                };
                            
                                request(options, function (error, response) {
                                    if (error) {
                                    throw new Error(error);
                                    }
                                    else {
                                        logger_1.logger.info('BOT-ZDG - Webhook N8N enviado com sucesso.');
                                    }
                                });
                            }
                            if (n8nStatus === "off"){
                                logger_1.logger.info("BOT-ZDG: Config N8N Off");
                            }
                        }
                        else {
                            logger_1.logger.warn("BOT-ZDG: Fora do horário de atendimento - N8N");
                            // delay(3000).then(function() {
                            //     //msg.reply("O horário de atendimento é entre " + inicioAtendimento.split(':')[0] + ":" + inicioAtendimento.split(':')[1] + " e " + terminoAtendimento.split(':')[0] + ":" + terminoAtendimento.split(':')[1]);
                            // }); 
                        }
                    }
                }
                else {
                    logger_1.logger.info("BOT-ZDG: Config N8N Off")
                }
            });	
            });
            // wbot mysql
            wbot.on('message', async msg => {
                //getGrupos
                const chatGroup = await msg.getChat();
                const groupConfig = await db.getGrupo();
                if (chatGroup.isGroup === true && groupConfig === 'off'){
                    return;
                }
                function delay(t, v) {
                    return new Promise(function(resolve) { 
                        setTimeout(resolve.bind(null, v), t)
                    });
                }
                delay(2000).then(async function() {
                wbot.sendPresenceAvailable();
                const keyword = msg.body.toLowerCase();
                const date = new Date();
                const horaAtual = date.getHours();
                if (horaAtual < 10){
                    const atual = "0" + date.getHours() + ":" + date.getMinutes() + ":" + date.getSeconds();
                    const inicioAtendimento = await db.getHorarioInicio();
                    const terminoAtendimento = await db.getHorarioTermino();
                    if (atual > inicioAtendimento && atual < terminoAtendimento){
                        const replyMessage = await db.getReply(keyword);
                        const chatBotStatus = await db.getChatBot(msg.from.split('@')[0]);
                        if(chatBotStatus === "ok" && !replyMessage){
                            const replyMessagePadrao = await db.getReply('ZDGPADRAO');
                            delay(3000).then(function() {
                                msg.reply(replyMessagePadrao || 'Cadastrar mensagem ZDGPadrao');
                            });
                            logger_1.logger.info("BOT-ZDG: Config Chatbot MYSQL ON (Sem mensagem cadastrada)");
                        }
                        if (chatBotStatus === "ok" && replyMessage !== false){
                            logger_1.logger.info(`Acessando MYSQL: ${sessionName} OK`);
                            logger_1.logger.info("BOT-ZDG: Config Chatbot MYSQL ON");
                            delay(3000).then(function() {
                                msg.reply(replyMessage);
                            });   
                        }
                        if (chatBotStatus === "off"){
                            logger_1.logger.info("BOT-ZDG: Config Chatbot MYSQL OFF");
                        }    
                }
                else {
                    logger_1.logger.warn("BOT-ZDG: Fora do horário de atendimento - MYSQL");
                    //  delay(3000).then(function() {
                    //      msg.reply("O horário de atendimento MYSQL é entre " + inicioAtendimento.split(':')[0] + ":" + inicioAtendimento.split(':')[1] + " e " + terminoAtendimento.split(':')[0] + ":" + terminoAtendimento.split(':')[1]);
                    //  });  
                }
                }
                if (horaAtual >= 10){
                    const atual = date.getHours() + ":" + date.getMinutes() + ":" + date.getSeconds();
                    const inicioAtendimento = await db.getHorarioInicio();
                    const terminoAtendimento = await db.getHorarioTermino();
                    if (atual > inicioAtendimento && atual < terminoAtendimento){
                        const replyMessage = await db.getReply(keyword);
                        const chatBotStatus = await db.getChatBot(msg.from.split('@')[0]);
                        if(chatBotStatus === "ok" && !replyMessage){
                            const replyMessagePadrao = await db.getReply('ZDGPADRAO');
                            delay(3000).then(function() {
                                msg.reply(replyMessagePadrao || 'Cadastrar mensagem ZDGPadrao');
                            });
                            logger_1.logger.info("BOT-ZDG: Config Chatbot MYSQL ON (Sem mensagem cadastrada)");
                        }
                        if (chatBotStatus === "ok" && replyMessage !== false){
                            logger_1.logger.info(`Acessando MYSQL: ${sessionName} OK`);
                            logger_1.logger.info("BOT-ZDG: Config Chatbot MYSQL ON");
                            delay(3000).then(function() {
                                msg.reply(replyMessage);
                            });   
                        }
                        if (chatBotStatus === "off"){
                            logger_1.logger.info("BOT-ZDG: Config Chatbot MYSQL OFF");
                        }    
                }
                else {
                    logger_1.logger.info("BOT-ZDG: Fora do horário de atendimento - MYSQL");
                    //  delay(3000).then(function() {
                    //      msg.reply("O horário de atendimento MYSQL é entre " + inicioAtendimento.split(':')[0] + ":" + inicioAtendimento.split(':')[1] + " e " + terminoAtendimento.split(':')[0] + ":" + terminoAtendimento.split(':')[1]);
                    //  });  
                }
                }
            });
            });
            //wbot dialogflow
            wbot.on('message', async msg => {
                //getGrupos
                const chatGroup = await msg.getChat();
                const groupConfig = await db.getGrupo();
                if (chatGroup.isGroup === true && groupConfig === 'off'){
                    return;
                }
                function delay(t, v) {
                    return new Promise(function(resolve) { 
                        setTimeout(resolve.bind(null, v), t)
                    });
                }
                delay(2000).then(async function() {
                wbot.sendPresenceAvailable();
                if (process.env.DIALOG_FLOW_STATUS === "on"){
                    logger_1.logger.info("BOT-ZDG: ENV Dialog ON")
                    //integração de texto dialogflow
                    let textoResposta = await executeQueries(process.env.DIALOG_FLOW_PROJECT_ID, msg.from, [msg.body], process.env.DIALOG_FLOW_LANGUAGE)
                    const dialogFlowStatus = await db.getDialogFlow(msg.from.split('@')[0]);
                    let textoRespostaAudio = await executeQueriesAudio(process.env.DIALOG_FLOW_PROJECT_ID, msg.from, [msg.body], process.env.DIALOG_FLOW_LANGUAGE);
                    const dialogFlowStatusAudio = await db.getDialogFlowAudio(msg.from.split('@')[0]);
                    const chat = await msg.getChat();
                    let intentStop = await executeQueriesIntentStop(process.env.DIALOG_FLOW_PROJECT_ID, msg.from, [msg.body], process.env.DIALOG_FLOW_LANGUAGE)
                    //dialogflow mensagens
                    async function detectIntent(
                        projectId,
                        sessionId,
                        query,
                        contexts,
                        languageCode
                    ) {
                        const sessionPath = sessionClient.projectAgentSessionPath(
                        projectId,
                        sessionId
                        );
                    
                        // The text query request.
                        const request = {
                        session: sessionPath,
                        queryInput: {
                            text: {
                            text: query,
                            languageCode: languageCode,
                            },
                        },
                        };
                    
                        if (contexts && contexts.length > 0) {
                        request.queryParams = {
                            contexts: contexts,
                        };
                        }
                    
                        const responses = await sessionClient.detectIntent(request);
                        return responses[0];
                    }
                    async function executeQueries(projectId, sessionId, queries, languageCode) {
                        let context;
                        let intentResponse;
                        for (const query of queries) {
                            try {
                                //console.log(`BOT-ZDG: DialogFlow Texto - Pergunta: ${query}`);
                                intentResponse = await detectIntent(
                                    projectId,
                                    sessionId,
                                    query,
                                    context,
                                    languageCode
                                );
                                //console.log('Enviando Resposta');
                                if (isBlank(intentResponse.queryResult.fulfillmentText)){
                                    //console.log('BOT-ZDG: Sem resposta definida no DialogFlow Texto');
                                    return null;   
                                }
                                else {
                                    //console.log('BOT-ZDG: Resposta definida no DialogFlow Texto');
                                    //console.log(intentResponse.queryResult.fulfillmentText);
                                    //return `${intentResponse.queryResult.fulfillmentText}`
                                    //console.log(intentResponse.queryResult.fulfillmentMessages);
                                    return JSON.stringify(intentResponse.queryResult.fulfillmentMessages)
                                }
                                
                            } catch (error) {
                                logger_1.logger.info("BOT-ZDG: Tipo de arquivo não reconhecido pelo dialogflow");
                            }
                        }
                    }
                    async function executeQueriesIntentStop(projectId, sessionId, queries, languageCode) {
                        let context;
                        let intentResponse;
                        for (const query of queries) {
                            try {
                                //console.log(`BOT-ZDG: DialogFlow Texto - Pergunta: ${query}`);
                                intentResponse = await detectIntent(
                                    projectId,
                                    sessionId,
                                    query,
                                    context,
                                    languageCode
                                );
                                //console.log('Enviando Resposta');
                                if (isBlank(intentResponse.queryResult.fulfillmentText)){
                                    //console.log('BOT-ZDG: Sem resposta definida no DialogFlow Texto');
                                    return null;   
                                }
                                else {
                                    //console.log('BOT-ZDG: Resposta definida no DialogFlow Texto');
                                    //console.log(intentResponse.queryResult.fulfillmentText);
                                    // return `${intentResponse.queryResult.fulfillmentText}`
                                    //console.log(intentResponse.queryResult.fulfillmentMessages);
                                    return JSON.stringify(intentResponse.queryResult)
                                }
                                
                            } catch (error) {
                                logger_1.logger.info("BOT-ZDG: Tipo de arquivo não reconhecido pelo dialogflow");
                            }
                        }
                    }
                    //dialogflow audio
                    async function detectIntentwithTTSResponse(projectId,
                        sessionId,
                        query,
                        languageCode) {
                        const sessionPath = sessionClient.projectAgentSessionPath(
                            projectId,
                            sessionId
                        );
                        // The audio query request
                        const request = {
                        session: sessionPath,
                        queryInput: {
                            text: {
                            text: query,
                            languageCode: languageCode,
                            },
                        },
                        outputAudioConfig: {
                            audioEncoding: 'OUTPUT_AUDIO_ENCODING_OGG_OPUS',
                        },
                        };
                        const responses = await sessionClient.detectIntent(request);
                        const audioFile = responses[0].outputAudio;
                        const outputFile = './public/' + sessionId + '.ogg';
                        util.promisify(fs.writeFile)(outputFile, audioFile, 'base64');
                        //console.log(`BOT-ZDG: Conteúdo do áudio gravado em: ${outputFile}`);
                        return responses[0];
                    }
                    async function executeQueriesAudio(projectId, sessionId, queries, languageCode) {
                        let intentResponse;
                        for (const query of queries) {
                            try {
                                //console.log(`BOT-ZDG: DialogFlow Áudio - Pergunta:: ${query}`);
                                intentResponse = await detectIntentwithTTSResponse(
                                    projectId,
                                    sessionId,
                                    query,
                                    languageCode
                                );
                                //console.log('BOT-ZDG: Enviando Resposta de Áudio');
                                if (isBlank(intentResponse.queryResult.fulfillmentText)){
                                    //console.log('BOT-ZDG: Sem resposta definida no DialogFlow Áudio');
                                    return null;   
                                }
                                else {
                                    //console.log('BOT-ZDG: Resposta definida no DialogFlow Áudio');
                                    //console.log(intentResponse.queryResult.fulfillmentText);
                                    return `${intentResponse.queryResult.fulfillmentText}`
                                }
                            } catch (error) {
                                logger_1.logger.info("BOT-ZDG: Tipo de arquivo não reconhecido pelo dialogflow");
                            }
                        }
                    }
                    try {
                        if(JSON.parse(intentStop).intent.displayName === process.env.DIALOG_FLOW_INTENT_STOP){
                            await db.setDialogOff(msg.from.replace(/\D/g,''));
                            await db.setDialogOffAudio(msg.from.replace(/\D/g,''));
                            logger_1.logger.info('BOT-ZDG: Dialogflow desligado pela intent de finalização - ' + JSON.parse(textoResposta).intent.displayName)
                            return;
                        }
                    } catch(e){
                        logger_1.logger.warn('BOT-ZDG: Não existe intent para essa interação.')
                    }
                    const date = new Date();
                    const horaAtual = date.getHours();
                    if (horaAtual < 10){
                        const atual = "0" + date.getHours() + ":" + date.getMinutes() + ":" + date.getSeconds();
                        const inicioAtendimento = await db.getHorarioInicio();
                        const terminoAtendimento = await db.getHorarioTermino();
                        if (atual < inicioAtendimento || atual > terminoAtendimento){
                            logger_1.logger.info("BOT-ZDG: Fora do horário de atendimento - DIALOG");
                            return;
                        }
                    }
                    if (horaAtual >= 10){
                        const atual = date.getHours() + ":" + date.getMinutes() + ":" + date.getSeconds();
                        const inicioAtendimento = await db.getHorarioInicio();
                        const terminoAtendimento = await db.getHorarioTermino();
                        if (atual < inicioAtendimento || atual > terminoAtendimento){
                            logger_1.logger.info("BOT-ZDG: Fora do horário de atendimento - DIALOG");
                            return;
                        }
                    }
                    if (dialogFlowStatus === "ok" && dialogFlowStatusAudio === "ok" && textoResposta !== null){
                            logger_1.logger.info("BOT-ZDG: Config Dialog Texto e Aúdio ON");
                            const mediaResposta = MessageMedia.fromFilePath('./public/' + msg.from + '.ogg');
                            delay(3000).then(async function() {
                                if(textoResposta === undefined){
                                    return
                                }
                                //msg.reply("*BOT ZDG:*\n" + textoResposta.replace(/\\n/g, '\n'));
                                for (const message of JSON.parse(textoResposta)){
                                    //console.log(JSON.stringify(message.text.text).replace('["','').replace('"]',''))
                                    try{
                                    const texto = JSON.stringify(message.text.text).replace('["','').replace('"]','');
                                    msg.reply(texto.replace(/\\n/g, '\n'));
                                    }catch(e){
                                        logger_1.logger.errorg('BOT-ZDG: error ' + e)
                                    }
                                  }
                            });    
                            delay(4000).then(function() {
                                if(textoRespostaAudio === undefined){
                                    return
                                }
                                msg.reply(textoRespostaAudio + "\n\n🔊 Estou gravando uma mensagem para você.");
                                //console.log("Enviando Aúdio");
                                chat.sendStateRecording();
                            });
                            delay(5000).then(function() {
                                wbot.sendMessage(msg.from, mediaResposta, {sendAudioAsVoice: true});
                            });  
                    }
                    if (dialogFlowStatus === "ok" && dialogFlowStatusAudio === "off" && textoResposta !== null){
                            logger_1.logger.info("BOT-ZDG: Config Dialog Texto ON - Áudio OFF");
                            delay(3000).then(async function() {
                                //msg.reply("*BOT ZDG:*\n" + textoResposta.replace(/\\n/g, '\n'));
                                for (const message of JSON.parse(textoResposta)){
                                    //console.log(JSON.stringify(message.text.text).replace('["','').replace('"]',''))
                                    try{
                                    const texto = JSON.stringify(message.text.text).replace('["','').replace('"]','');
                                    msg.reply(texto.replace(/\\n/g, '\n'));
                                    }catch(e){
                                        logger_1.logger.error('BOT-ZDG: error ' + e)
                                    }
                                  }
                            });  
                    }
                    if (dialogFlowStatus === "off" && dialogFlowStatusAudio === "ok" && textoResposta !== null){
                            logger_1.logger.info("BOT-ZDG: Config Dialog Texto OFF - Aúdio ON");
                            const mediaResposta = MessageMedia.fromFilePath('./public/' + msg.from + '.ogg');
                            delay(4000).then(function() {
                                msg.reply(textoRespostaAudio + "\n\n🔊 Estou gravando uma mensagem para você.");
                                //console.log("Enviando Aúdio");
                                chat.sendStateRecording();
                            });
                            delay(5000).then(function() {
                                wbot.sendMessage(msg.from, mediaResposta, {sendAudioAsVoice: true});
                            });  
                    }
                    if (dialogFlowStatus === "off" && dialogFlowStatusAudio === "off" && textoResposta !== null){
                        logger_1.logger.info("BOT-ZDG: Config Dialog Off");
                    }
                }
                if (process.env.DIALOG_FLOW_STATUS !== "on"){
                    logger_1.logger.info('BOT-ZDG: ENV Dialog OFF')
                }
            });
            });
            // wbot chatgpt
            wbot.on('message', async msg => {
                //getGrupos
                const chatGroup = await msg.getChat();
                const groupConfig = await db.getGrupo();
                if (chatGroup.isGroup === true && groupConfig === 'off'){
                    return;
                }
                function delay(t, v) {
                    return new Promise(function(resolve) { 
                        setTimeout(resolve.bind(null, v), t)
                    });
                }
                // gera resposta em texto
                // const getDavinciResponse = async (clientText) => {
                //     const options = {
                //         model: "text-davinci-003", // Modelo GPT a ser usado
                //         prompt: clientText, // Texto enviado pelo usuário
                //         temperature: 1, // Nível de variação das respostas geradas, 1 é o máximo
                //         max_tokens: 4000 // Quantidade de tokens (palavras) a serem retornadas pelo bot, 4000 é o máximo
                //     }

                //     try {
                //         const response = await openai.createCompletion(options)
                //         let botResponse = ""
                //         response.data.choices.forEach(({ text }) => {
                //             botResponse += text
                //         })
                //         return `Chat GPT 🤖\n\n ${botResponse.trim()}`
                //     } catch (e) {
                //         return `❌ OpenAI Response Error: ${e.response.data.error.message}`
                //     }
                // }
                // gera resposta em texto full prompt
                let conversationContext = "";
                const getDavinciResponse = async (clientText) => {
                    const fullPrompt = conversationContext + clientText;
                    const options = {
                        model: "text-davinci-003", // Modelo GPT a ser usado
                        prompt: fullPrompt, // Texto enviado pelo usuário
                        temperature: 1, // Nível de variação das respostas geradas, 1 é o máximo
                        max_tokens: 4000 // Quantidade de tokens (palavras) a serem retornadas pelo bot, 4000 é o máximo
                    }
                    try {
                        const response = await openai.createCompletion(options)
                        let botResponse = ""
                        conversationContext = fullPrompt + response.data.choices.forEach(({ text }) => {
                            botResponse += text
                        })
                        return ` Chat GPT 🤖\n\n ${botResponse.trim()}`
                    } catch (e) {
                        return `❌ OpenAI Response Error: ${e.response.data.error.message}`
                    }
                }
                // gera a url da imagem
                const getDalleResponse = async (clientText) => {
                    const options = {
                        prompt: clientText, // Descrição da imagem
                        n: 1, // Número de imagens a serem geradas
                        size: "1024x1024", // Tamanho da imagem
                    }

                    try {
                        const response = await openai.createImage(options);
                        return response.data.data[0].url
                    } catch (e) {
                        return `❌ OpenAI Response Error: ${e.response.data.error.message}`
                    }
                }
                delay(2000).then(async function() {
                wbot.sendPresenceAvailable();
                if (process.env.CHATGPT === "on"){
                    logger_1.logger.info("BOT-ZDG: ENV Config ChatGPT On")
                    const date = new Date();
                    const horaAtual = date.getHours();
                    if (horaAtual < 10){
                        const atual = "0" + date.getHours() + ":" + date.getMinutes() + ":" + date.getSeconds();
                        const inicioAtendimento = await db.getHorarioInicio();
                        const terminoAtendimento = await db.getHorarioTermino();
                        if (atual > inicioAtendimento && atual < terminoAtendimento){
                            const gptStatus = await db.getGPT(msg.from.split('@')[0]);
                            if(gptStatus === "ok"){
                                delay(1000).then(function() {
                                    const msgChatGPT = msg.body;
                                    // mensagem de texto
                                    if (msgChatGPT.includes('/gpt ')) {
                                        const index = msgChatGPT.indexOf(" ");
                                        const question = msgChatGPT.substring(index + 1);
                                        getDavinciResponse(question).then((response) => {
                                        wbot.sendMessage(msg.from, response)
                                        })
                                    }
                                    // imagem
                                    if (msgChatGPT.includes('/gptimg ')) {
                                        const index = msgChatGPT.indexOf(" ");
                                        const imgDescription = msgChatGPT.substring(index + 1);
                                        getDalleResponse(imgDescription, msg).then(async (imgUrl) => {
                                        const media = await MessageMedia.fromUrl(imgUrl);
                                        wbot.sendMessage(msg.from, media, {caption: imgDescription})
                                        })
                                    }
                                });
                                logger_1.logger.info("BOT-ZDG: Config Chatbot GPT ON ");
                            }
                            if (gptStatus === "off"){
                                logger_1.logger.info("BOT-ZDG: Config Chatbot GPT OFF");
                            }    
                    }
                    else {
                        logger_1.logger.warn("BOT-ZDG: Fora do horário de atendimento - MYSQL");
                    }
                    }
                    if (horaAtual >= 10){
                        const atual = date.getHours() + ":" + date.getMinutes() + ":" + date.getSeconds();
                        const inicioAtendimento = await db.getHorarioInicio();
                        const terminoAtendimento = await db.getHorarioTermino();
                        if (atual > inicioAtendimento && atual < terminoAtendimento){
                            const gptStatus = await db.getGPT(msg.from.split('@')[0]);
                            if(gptStatus === "ok"){
                                delay(1000).then(function() {
                                    const msgChatGPT = msg.body;
                                    // mensagem de texto
                                    if (msgChatGPT.includes('/gpt ')) {
                                        const index = msgChatGPT.indexOf(" ");
                                        const question = msgChatGPT.substring(index + 1);
                                        getDavinciResponse(question).then((response) => {
                                            wbot.sendMessage(msg.from, response)
                                        })
                                    }
                                    // imagem
                                    if (msgChatGPT.includes('/gptimg ')) {
                                        const index = msgChatGPT.indexOf(" ");
                                        const imgDescription = msgChatGPT.substring(index + 1);
                                        getDalleResponse(imgDescription, msg).then(async (imgUrl) => {
                                        const media = await MessageMedia.fromUrl(imgUrl);
                                        wbot.sendMessage(msg.from, media, {caption: imgDescription})
                                        })
                                    }
                                });
                                logger_1.logger.info("BOT-ZDG: Config Chatbot GPT ON ");
                            }   
                    }
                    else {
                        logger_1.logger.warn("BOT-ZDG: Fora do horário de atendimento - MYSQL");
                        //  delay(3000).then(function() {
                        //      msg.reply("O horário de atendimento MYSQL é entre " + inicioAtendimento.split(':')[0] + ":" + inicioAtendimento.split(':')[1] + " e " + terminoAtendimento.split(':')[0] + ":" + terminoAtendimento.split(':')[1]);
                        //  });  
                    }
                    }
                }
                if (process.env.CHATGPT !== "on"){
                    logger_1.logger.info('BOT-ZDG: ENV Dialog OFF')
                }
            });
            });
        }
        catch (err) {
            logger_1.logger.error(err);
        }
    });
});
exports.getWbot = (whatsappId) => {
    const sessionIndex = sessions.findIndex(s => s.id === whatsappId);
    if (sessionIndex === -1) {
        throw new AppError_1.default("ERR_WAPP_NOT_INITIALIZED");
    }
    return sessions[sessionIndex];
};
exports.removeWbot = (whatsappId) => {
    try {
        const sessionIndex = sessions.findIndex(s => s.id === whatsappId);
        if (sessionIndex !== -1) {
            sessions[sessionIndex].destroy();
            sessions.splice(sessionIndex, 1);
        }
    }
    catch (err) {
        logger_1.logger.error(err);
    }
};
