"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const AppError_1 = __importDefault(require("../../errors/AppError"));
const Contact_1 = __importDefault(require("../../models/Contact"));
const SetDialogContact = __importDefault(require("../../helpers/SetDialogContact"));
const GetDialogContact = __importDefault(require("../../helpers/GetDialogContact"));
const SetDialogAudioContact = __importDefault(require("../../helpers/SetDialogAudioContact"));
const GetDialogAudioContact = __importDefault(require("../../helpers/GetDialogAudioContact"));
const SetN8NContact = __importDefault(require("../../helpers/SetN8NContact"));
const GetN8NContact = __importDefault(require("../../helpers/GetN8NContact"));
const SetGPTContact = __importDefault(require("../../helpers/SetGPTContact"));
const GetGPTContact = __importDefault(require("../../helpers/GetGPTContact"));
const SetChatBotContact = __importDefault(require("../../helpers/SetChatBotContact"));
const GetChatBotContact = __importDefault(require("../../helpers/GetChatBotContact"));
const SetTagContact = __importDefault(require("../../helpers/SetTagContact"));
const GetTagContact = __importDefault(require("../../helpers/GetTagContact"));
const logger_1 = require("../../utils/logger");
const request = require('request');
const CreateContactService = ({ name, number, email = "", extraInfo = [] }) => __awaiter(void 0, void 0, void 0, function* () {
    const numberExists = yield Contact_1.default.findOne({
        where: { number }
    });
    if (numberExists) {
        throw new AppError_1.default("ERR_DUPLICATED_CONTACT");
    }
    const contact = yield Contact_1.default.create({
        name,
        number,
        email,
        extraInfo
    }, {
        include: ["extraInfo"]
    });
    const getDialogFlowContact = yield GetDialogContact.default(number);
    if (getDialogFlowContact === true){
        //console.log('BOT-ZDG: Contato já existe para o DialogFlow');
    }
    if (getDialogFlowContact === false){
        //console.log('BOT-ZDG: Contato adicionado para o DialogFlow');
        yield SetDialogContact.default(number);
    }
    const getDialogFlowAudioContact = yield GetDialogAudioContact.default(number);
    if (getDialogFlowAudioContact === true){
        //console.log('BOT-ZDG: Contato já existe para o DialogFlow Audio');
    }
    if (getDialogFlowAudioContact === false){
        //console.log('BOT-ZDG: Contato adicionado para o DialogFlow Audio');
        yield SetDialogAudioContact.default(number);
    }
    const getN8NContact = yield GetN8NContact.default(number);
    if (getN8NContact === true){
        //console.log('BOT-ZDG: Contato já existe para o N8N');
    }
    if (getN8NContact === false){
        //console.log('BOT-ZDG: Contato adicionado para o N8N');
        yield SetN8NContact.default(number);
    }
    const getGPTContact = yield GetGPTContact.default(number);
    if (getGPTContact === true){
        //console.log('BOT-ZDG: Contato já existe para o GPT');
    }
    if (getGPTContact === false){
        //console.log('BOT-ZDG: Contato adicionado para o GPT');
        yield SetGPTContact.default(number);
    }
    const getChatBotContact = yield GetChatBotContact.default(number);
    if (getChatBotContact === true){
        //console.log('BOT-ZDG: Contato já existe para o BOT MySQL');
    }
    if (getChatBotContact === false){
        //console.log('BOT-ZDG: Contato adicionado para o BOT MySQL');
        yield SetChatBotContact.default(number);
    }
    const getTagContact = yield GetTagContact.default(number);
    if (getTagContact === true){
        //console.log('BOT-ZDG: Contato já existe para o BOT MySQL');
    }
    if (getTagContact === false){
        //console.log('BOT-ZDG: Contato adicionado para o BOT MySQL');
        yield SetTagContact.default(number);
    }
    if (process.env.createContactService === "on") {
        try {
            var method = "createContactService"
            var options = {
                'method': 'POST',
                'url': process.env.N8N_WEBHOOK,
                'headers': {
                'Content-Type': 'application/json'
                },
                json: { name, number, email, method }
            };
            request(options, function (error, response) {
                if (error) {
                throw new Error(error);
                }
                else {
                    logger_1.logger.info('BOT-ZDG - Webhook contato criado enviado com sucesso.');
                }
            });
        } catch(e){
            logger_1.logger.info('Sem webhook setado')
        }
    }
    return contact;
});
exports.default = CreateContactService;
