"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const AppError_1 = __importDefault(require("../../errors/AppError"));
const CheckContactOpenTickets_1 = __importDefault(require("../../helpers/CheckContactOpenTickets"));
const GetDefaultWhatsApp_1 = __importDefault(require("../../helpers/GetDefaultWhatsApp"));
const Ticket_1 = __importDefault(require("../../models/Ticket"));
const User_1 = __importDefault(require("../../models/User"));
const ShowContactService_1 = __importDefault(require("../ContactServices/ShowContactService"));
const InsertCardLane = __importDefault(require("../../helpers/InsertCardsLane"));
const GetCardsId = __importDefault(require("../../helpers/GetCardsId"));
const logger_1 = require("../../utils/logger");
const request = require('request');
const CreateTicketService = ({ contactId, status, userId, queueId }) => __awaiter(void 0, void 0, void 0, function* () {
    const defaultWhatsapp = yield GetDefaultWhatsApp_1.default(userId);
    yield CheckContactOpenTickets_1.default(contactId, defaultWhatsapp.id);
    const { isGroup } = yield ShowContactService_1.default(contactId);
    if (queueId === undefined) {
        const user = yield User_1.default.findByPk(userId, { include: ["queues"] });
        queueId = (user === null || user === void 0 ? void 0 : user.queues.length) === 1 ? user.queues[0].id : undefined;
    }
    const { id } = yield defaultWhatsapp.$create("ticket", {
        contactId,
        status,
        isGroup,
        userId,
        queueId
    });
    const ticket = yield Ticket_1.default.findByPk(id, { include: ["contact"] });
    if (!ticket) {
        throw new AppError_1.default("ERR_CREATING_TICKET");
    }
    //yield InsertCardLane.default('0', ticket.dataValues.id.toString(), 'Ticket nº ' + ticket.dataValues.id.toString(), ticket.contact.dataValues.number, ticket.contact.dataValues.name);
    const cardsId = yield GetCardsId.default(ticket.dataValues.id.toString())
    if (cardsId === false){
        yield InsertCardLane.default('lane1', ticket.dataValues.id.toString(), ticket.contact.dataValues.name, ticket.contact.dataValues.number, ticket.dataValues.id.toString(), 'pending');
    }
    if (process.env.createTicketService === "on") {
        try {
            var method = "createTicketService"
            var options = {
                'method': 'POST',
                'url': process.env.N8N_WEBHOOK,
                'headers': {
                'Content-Type': 'application/json'
                },
                json: { contactId, status, userId, queueId, method }
            };
            request(options, function (error, response) {
                if (error) {
                throw new Error(error);
                }
                else {
                    logger_1.logger.info('BOT-ZDG - Webhook ticket criado enviado com sucesso.');
                }
            });
        } catch(e){
            logger_1.logger.info('Sem webhook setado')
        }
    }
    return ticket;
});
exports.default = CreateTicketService;
