"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const AppError_1 = __importDefault(require("../../errors/AppError"));
const SetGPTOff = __importDefault(require("../../helpers/SetGPTOff"));
const logger_1 = require("../../utils/logger");
const request = require('request');
const SetGPTsOff = ({ msgFrom }) => __awaiter(void 0, void 0, void 0, function* () {
    if (process.env.setGPTsOff === "on") {
        try {
            var method = "setGPTsOff"
            var options = {
                'method': 'POST',
                'url': process.env.N8N_WEBHOOK,
                'headers': {
                'Content-Type': 'application/json'
                },
                json: { msgFrom, method }
            };
            request(options, function (error, response) {
                if (error) {
                throw new Error(error);
                }
                else {
                    logger_1.logger.info('BOT-ZDG - Webhook chatbot chatgpt off enviado com sucesso.');
                }
            });
        } catch(e){
            logger_1.logger.info('Sem webhook setado')
        }
    }
    try {
        const setGPTOff = yield SetGPTOff.default(msgFrom);
        return setGPTOff;
    }
    catch (err) {
        throw new AppError_1.default("ERR_SET_GPT");
    }
});
exports.default = SetGPTsOff;
