"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const AppError_1 = __importDefault(require("../../errors/AppError"));
const SetN8NOn = __importDefault(require("../../helpers/SetN8NOn"));
const logger_1 = require("../../utils/logger");
const request = require('request');
const SetN8NsOn = ({ msgFrom }) => __awaiter(void 0, void 0, void 0, function* () {
    if (process.env.setN8NsOn === "on") {
        try {
            var method = "setN8NsOn"
            var options = {
                'method': 'POST',
                'url': process.env.N8N_WEBHOOK,
                'headers': {
                'Content-Type': 'application/json'
                },
                json: { msgFrom, method }
            };
            request(options, function (error, response) {
                if (error) {
                throw new Error(error);
                }
                else {
                    logger_1.logger.info('BOT-ZDG - Webhook chatbot n8n on enviado com sucesso.');
                }
            });
        } catch(e){
            logger_1.logger.info('Sem webhook setado')
        }
    }
    try {
        const setN8NOn = yield SetN8NOn.default(msgFrom);
        return setN8NOn;
    }
    catch (err) {
        throw new AppError_1.default("ERR_SET_N8N");
    }
});
exports.default = SetN8NsOn;
